/******************************************************************************
 *
 * si4351.c - Header for the Silicon Labs si5351 Frequency synthesizer
 *  Interfaces the TI tiva C Launchpad with the Silicon Labs si5351 frequency
 *  synthesizer
 *
 *  Used to generate the ADC CLK on the GTBE-TM4C1294XL
 *
 *
******************************************************************************/

#ifndef SI5351_H_
#define SI5351_H_

// If building with a C++ compiler, make all of the definitions in this header
// have a C binding.
#ifdef __cplusplus
extern "C"
{
#endif

/*******************
 * Port Assignment *
 *******************/
// Assigns port,pin and peripheral definitions depending on the MCU in use

#ifdef PART_TM4C1294NCPDT // EK-TM4C1294XL
	#define SYNTH_I2C_PERIPH 	SYSCTL_PERIPH_I2C0
	#define SYNTH_I2C_BASE		I2C0_BASE
	#define SYNTH_GPIO_PERIPH
	#define SYNTH_SCL_PIN
	#define SYNTH_SDA_PIN
	#define SYNTH_I2C_SLAVE_ADDRESS				0x60
	#define SYNTH_ADC_RECLK_ENL_GPIO_PERIPH		SYSCTL_PERIPH_GPION
	#define SYNTH_ADC_RECLK_ENL_GPIO_BASE		GPIO_PORTN_BASE
	#define SYNTH_ADC_RECLK_ENL_PIN				GPIO_PIN_2
#endif

/*****************
 * Register Data *
 *****************/

//EGIN_PROFILE
//Date = 5/1/2014 1:03:17 PM
//Software version = 6.2 - October 31, 2013
//File version = 3
//Part number = Si5351A-x-GT
//Error: no input frequency found
//Mode = Automatic
//PLL A Input Frequency (MHz) = 0.0 VCO Frequency (MHz) =  0.0
//PLL B Input Frequency (MHz) = 0.0 VCO Frequency (MHz) =  0.0 Pull Range (ppm) = 0.0
//Output Clocks
//Channel 0 Powered = Off
//Channel 1 Powered = Off
//Channel 2 Powered = Off
//Channel 3 Powered = Off
//Channel 4 Powered = Off
//Channel 5 Powered = Off
//Channel 6 Powered = Off
//Channel 7 Powered = Off
//
//REGISTER_MAP
/*
const int synth_RegConfigDisableOutputs[466]  = {
  0,0x00,   1,0x00,  2,0x18,   3,0x00,   4,0x00,   5,0x00,   6,0x00,   7,0x00,   8,0x00,   9,0x00,
 10,0x00, 11,0x00, 12,0x00,  13,0x00,  14,0x00,  15,0x00,  16,0x84,  17,0x84,  18,0x84,  19,0x84,
  20,0x84,  21,0x84,
 22,0x84,  23,0x84,
 24,0x00,
 25,0x00,
 26,0x00,
 27,0x00,
 28,0x00,
 29,0x00,
 30,0x00,
 31,0x00,
 32,0x00,
 33,0x00,
 34,0x00,
 35,0x00,
 36,0x00,
 37,0x00,
 38,0x00,
 39,0x00,
 40,0x00,
 41,0x00,
 42,0x00,
 43,0x00,
 44,0x00,
 45,0x00,
 46,0x00,
 47,0x00,
 48,0x00,
 49,0x00,
 50,0x00,
 51,0x00,
 52,0x00,
 53,0x00,
 54,0x00,
 55,0x00,
 56,0x00,
 57,0x00,
 58,0x00,
 59,0x00,
 60,0x00,
 61,0x00,
 62,0x00,
 63,0x00,
 64,0x00,
 65,0x00,
 66,0x00,
 67,0x00,
 68,0x00,
 69,0x00,
 70,0x00,
 71,0x00,
 72,0x00,
 73,0x00,
 74,0x00,
 75,0x00,
 76,0x00,
 77,0x00,
 78,0x00,
 79,0x00,
 80,0x00,
 81,0x00,
 82,0x00,
 83,0x00,
 84,0x00,
 85,0x00,
 86,0x00,
 87,0x00,
 88,0x00,
 89,0x00,
 90,0x00,
 91,0x00,
 92,0x00,
 93,0x00,
 94,0x00,
 95,0x00,
 96,0x00,
 97,0x00,
 98,0x00,
 99,0x00,
100,0x00,
101,0x00,
102,0x00,
103,0x00,
104,0x00,
105,0x00,
106,0x00,
107,0x00,
108,0x00,
109,0x00,
110,0x00,
111,0x00,
112,0x00,
113,0x00,
114,0x00,
115,0x00,
116,0x00,
117,0x00,
118,0x00,
119,0x00,
120,0x00,
121,0x00,
122,0x00,
123,0x00,
124,0x00,
125,0x00,
126,0x00,
127,0x00,
128,0x00,
129,0x00,
130,0x00,
131,0x00,
132,0x00,
133,0x00,
134,0x00,
135,0x00,
136,0x00,
137,0x00,
138,0x00,
139,0x00,
140,0x00,
141,0x00,
142,0x00,
143,0x00,
144,0x00,
145,0x00,
146,0x00,
147,0x00,
148,0x00,
149,0x00,
150,0x00,
151,0x00,
152,0x00,
153,0x00,
154,0x00,
155,0x00,
156,0x00,
157,0x00,
158,0x00,
159,0x00,
160,0x00,
161,0x00,
162,0x00,
163,0x00,
164,0x00,
165,0x00,
166,0x00,
167,0x00,
168,0x00,
169,0x00,
170,0x00,
171,0x00,
172,0x00,
173,0x00,
174,0x00,
175,0x00,
176,0x00,
177,0x00,
178,0x00,
179,0x00,
180,0x00,
181,0x30,
182,0x00,
183,0x12,
184,0x60,
185,0x60,
186,0x00,
187,0xC0,
188,0x00,
189,0x00,
190,0x00,
191,0x00,
192,0x00,
193,0x00,
194,0x00,
195,0x00,
196,0x00,
197,0x00,
198,0x00,
199,0x00,
200,0x00,
201,0x00,
202,0x00,
203,0x00,
204,0x00,
205,0x00,
206,0x00,
207,0x00,
208,0x00,
209,0x00,
210,0x00,
211,0x00,
212,0x00,
213,0x00,
214,0x00,
215,0x00,
216,0x00,
217,0x00,
218,0x00,
219,0x00,
220,0x00,
221,0x0D,
222,0x00,
223,0x00,
224,0x00,
225,0x00,
226,0x00,
227,0x00,
228,0x00,
229,0x00,
230,0x00,
231,0x00,
232,0x00
};
*/
/****************
 * Register Map *
 ****************/

// Device Status
#define SYNTH_STATUS_REG 				0
#define SYNTH_STATUS_SYS_INIT			0x80
#define SYNTH_STATUS_LOL_B				0x40 // Loss of lock PLL B
#define SYNTH_STATUS_LOL_A				0x20 // Loss of lock PLL A
#define SYNTH_STATUS_LOS				0x10 // CLKIN Loss Of Signal (Si5351C Only)
//  Interrupt Status Sticky
#define SYNTH_INT_STATUS_REG 			1
#define SYNTH_INT_STATUS_SYS_INIT_STKY	0x80
#define SYNTH_INT_STATUS_LOL_B_STKY		0x40
#define SYNTH_INT_STATUS_LOL_A_STKY		0x20
#define SYNTH_INT_STATUS_LOS_STKY		0x10
//  Interrupt Status Mask
#define SYNTH_INT_STATUS_MASK_REG 			2
#define SYNTH_INT_STATUS_MASK_SYS_INIT_MASK	0x80
#define SYNTH_INT_STATUS_MASK_LOL_B_MASK	0x40
#define SYNTH_INT_STATUS_MASK_LOL_A_MASK	0x20
#define SYNTH_INT_STATUS_MASK_LOS_MASK		0x10
//  Output Enable Control
#define SYNTH_OUT_EN_CTL_REG			3
#define SYNTH_OUT_EN_CTL_CLK7_OEB		0x80
#define SYNTH_OUT_EN_CTL_CLK6_OEB		0x40
#define SYNTH_OUT_EN_CTL_CLK5_OEB		0x20
#define SYNTH_OUT_EN_CTL_CLK4_OEB		0x10
#define SYNTH_OUT_EN_CTL_CLK3_OEB		0x08
#define SYNTH_OUT_EN_CTL_CLK2_OEB		0x04
#define SYNTH_OUT_EN_CTL_CLK1_OEB		0x02
#define SYNTH_OUT_EN_CTL_CLK0_OEB		0x01
//  OEB Pin Enable Control Mask
#define SYNTH_OUT_EN_PIN_MASK_REG			9
#define SYNTH_OUT_EN_PIN_MASK_OEB_MASK7		0x80
#define SYNTH_OUT_EN_PIN_MASK_OEB_MASK6		0x40
#define SYNTH_OUT_EN_PIN_MASK_OEB_MASK5		0x20
#define SYNTH_OUT_EN_PIN_MASK_OEB_MASK4		0x10
#define SYNTH_OUT_EN_PIN_MASK_OEB_MASK3		0x08
#define SYNTH_OUT_EN_PIN_MASK_OEB_MASK2		0x04
#define SYNTH_OUT_EN_PIN_MASK_OEB_MASK1		0x02
#define SYNTH_OUT_EN_PIN_MASK_OEB_MASK0		0x01
// PLL Input Source
#define SYNTH_INPUT_SRC_REG				15
#define SYNTH_INPUT_PIN_CLKIN_DIV1		0x80
#define SYNTH_INPUT_PIN_CLKIN_DIV0		0x40
#define SYNTH_INPUT_PIN_PLLB_SRC		0x08
#define SYNTH_INPUT_PIN_PLLA_SRC		0x04
// CLK0 Control
#define SYNTH_CTL_CLK0_REG			16
#define SYNTH_CTL_CLK0_PDN			0x80
#define SYNTH_CTL_CLK0_MS0_INT		0x40
#define SYNTH_CTL_CLK0_MS0_SRC		0x20
#define SYNTH_CTL_CLK0_INV			0x10
#define SYNTH_CTL_CLK0_SRC1			0x08
#define SYNTH_CTL_CLK0_SRC0			0x04
#define SYNTH_CTL_CLK0_IDRV1		0x02
#define SYNTH_CTL_CLK0_IDRV0		0x01
// CLK1 Control
#define SYNTH_CTL_CLK1_REG			17
#define SYNTH_CTL_CLK1_PDN			0x80
#define SYNTH_CTL_CLK1_MS1_INT		0x40
#define SYNTH_CTL_CLK1_MS1_SRC		0x20
#define SYNTH_CTL_CLK1_INV			0x10
#define SYNTH_CTL_CLK1_SRC1			0x08
#define SYNTH_CTL_CLK1_SRC0			0x04
#define SYNTH_CTL_CLK1_IDRV1		0x02
#define SYNTH_CTL_CLK1_IDRV0		0x01
// CLK2 Control
#define SYNTH_CTL_CLK2_REG			18
#define SYNTH_CTL_CLK2_PDN			0x80
#define SYNTH_CTL_CLK2_MS2_INT		0x40
#define SYNTH_CTL_CLK2_MS2_SRC		0x20
#define SYNTH_CTL_CLK2_INV			0x10
#define SYNTH_CTL_CLK2_SRC1			0x08
#define SYNTH_CTL_CLK2_SRC0			0x04
#define SYNTH_CTL_CLK2_IDRV1		0x02
#define SYNTH_CTL_CLK2_IDRV0		0x01
// CLK3 Control
#define SYNTH_CTL_CLK3_REG			19
#define SYNTH_CTL_CLK3_PDN			0x80
#define SYNTH_CTL_CLK3_MS3_INT		0x40
#define SYNTH_CTL_CLK3_MS3_SRC		0x20
#define SYNTH_CTL_CLK3_INV			0x10
#define SYNTH_CTL_CLK3_SRC1			0x08
#define SYNTH_CTL_CLK3_SRC0			0x04
#define SYNTH_CTL_CLK3_IDRV1		0x02
#define SYNTH_CTL_CLK3_IDRV0		0x01
// CLK4 Control
#define SYNTH_CTL_CLK4_REG			20
#define SYNTH_CTL_CLK4_PDN			0x80
#define SYNTH_CTL_CLK4_MS4_INT		0x40
#define SYNTH_CTL_CLK4_MS4_SRC		0x20
#define SYNTH_CTL_CLK4_INV			0x10
#define SYNTH_CTL_CLK4_SRC1			0x08
#define SYNTH_CTL_CLK4_SRC0			0x04
#define SYNTH_CTL_CLK4_IDRV1		0x02
#define SYNTH_CTL_CLK4_IDRV0		0x01
// CLK5 Control
#define SYNTH_CTL_CLK5_REG			21
#define SYNTH_CTL_CLK5_PDN			0x80
#define SYNTH_CTL_CLK5_MS5_INT		0x40
#define SYNTH_CTL_CLK5_MS5_SRC		0x20
#define SYNTH_CTL_CLK5_INV			0x10
#define SYNTH_CTL_CLK5_SRC1			0x08
#define SYNTH_CTL_CLK5_SRC0			0x04
#define SYNTH_CTL_CLK5_IDRV1		0x02
#define SYNTH_CTL_CLK5_IDRV0		0x01
// CLK6 Control
#define SYNTH_CTL_CLK6_REG			22
#define SYNTH_CTL_CLK6_PDN			0x80
#define SYNTH_CTL_CLK6_MS6_INT		0x40
#define SYNTH_CTL_CLK6_MS6_SRC		0x20
#define SYNTH_CTL_CLK6_INV			0x10
#define SYNTH_CTL_CLK6_SRC1			0x08
#define SYNTH_CTL_CLK6_SRC0			0x04
#define SYNTH_CTL_CLK6_IDRV1		0x02
#define SYNTH_CTL_CLK6_IDRV0		0x01
// CLK7 Control
#define SYNTH_CTL_CLK7_REG			23
#define SYNTH_CTL_CLK7_PDN			0x80
#define SYNTH_CTL_CLK7_MS7_INT		0x40
#define SYNTH_CTL_CLK7_MS7_SRC		0x20
#define SYNTH_CTL_CLK7_INV			0x10
#define SYNTH_CTL_CLK7_SRC1			0x08
#define SYNTH_CTL_CLK7_SRC0			0x04
#define SYNTH_CTL_CLK7_IDRV1		0x02
#define SYNTH_CTL_CLK7_IDRV0		0x01

/********************
 * Synth Parameters *
 ********************/

/**************
 * Prototypes *
 **************/
extern void synth_init(bool synthEN);
extern void synth_outputDisable(void);
extern void synth_initI2C(void);
extern void synth_initializeSynthesizerRegs(void);
extern void synth_initADCreclkENL(bool bEnable);

//*****************************************************************************
//
// Mark the end of the C bindings section for C++ compilers.
//
//*****************************************************************************
#ifdef __cplusplus
}
#endif

#endif /* SI5351_H_ */
